/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.ClockworkBearingBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.ClockworkContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.IBearingTileEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.INamedIconOptions;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import org.apache.commons.lang3.tuple.Pair;

public class ClockworkBearingTileEntity
extends KineticTileEntity
implements IBearingTileEntity,
IDisplayAssemblyExceptions {
    protected ControlledContraptionEntity hourHand;
    protected ControlledContraptionEntity minuteHand;
    protected float hourAngle;
    protected float minuteAngle;
    protected float clientHourAngleDiff;
    protected float clientMinuteAngleDiff;
    protected boolean running;
    protected boolean assembleNextTick;
    protected AssemblyException lastException;
    protected ScrollOptionBehaviour<ClockHands> operationMode;
    private float prevForcedAngle;

    public ClockworkBearingTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(3);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.operationMode = new ScrollOptionBehaviour<ClockHands>(ClockHands.class, (class_2561)Lang.translateDirect("contraptions.clockwork.clock_hands", new Object[0]), this, this.getMovementModeSlot());
        this.operationMode.requiresWrench();
        behaviours.add(this.operationMode);
        this.registerAwardables(behaviours, AllAdvancements.CLOCKWORK_BEARING);
    }

    @Override
    public boolean isWoodenTop() {
        return false;
    }

    @Override
    public void tick() {
        float newAngle;
        super.tick();
        if (this.field_11863.field_9236) {
            this.prevForcedAngle = this.hourAngle;
            this.clientMinuteAngleDiff /= 2.0f;
            this.clientHourAngleDiff /= 2.0f;
        }
        if (!this.field_11863.field_9236 && this.assembleNextTick) {
            this.assembleNextTick = false;
            if (this.running) {
                boolean canDisassemble = true;
                if (this.speed == 0.0f && (canDisassemble || this.hourHand == null || this.hourHand.getContraption().getBlocks().isEmpty())) {
                    if (this.hourHand != null) {
                        this.hourHand.getContraption().stop(this.field_11863);
                    }
                    if (this.minuteHand != null) {
                        this.minuteHand.getContraption().stop(this.field_11863);
                    }
                    this.disassemble();
                }
                return;
            }
            this.assemble();
            return;
        }
        if (!this.running) {
            return;
        }
        if (this.hourHand == null || !this.hourHand.isStalled()) {
            newAngle = this.hourAngle + this.getHourArmSpeed();
            this.hourAngle = newAngle % 360.0f;
        }
        if (this.minuteHand == null || !this.minuteHand.isStalled()) {
            newAngle = this.minuteAngle + this.getMinuteArmSpeed();
            this.minuteAngle = newAngle % 360.0f;
        }
        this.applyRotations();
    }

    @Override
    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    protected void applyRotations() {
        class_2680 blockState = this.method_11010();
        class_2350.class_2351 axis = class_2350.class_2351.field_11048;
        if (blockState.method_28498((class_2769)class_2741.field_12525)) {
            axis = ((class_2350)blockState.method_11654((class_2769)class_2741.field_12525)).method_10166();
        }
        if (this.hourHand != null) {
            this.hourHand.setAngle(this.hourAngle);
            this.hourHand.setRotationAxis(axis);
        }
        if (this.minuteHand != null) {
            this.minuteHand.setAngle(this.minuteAngle);
            this.minuteHand.setRotationAxis(axis);
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.hourHand != null && !this.field_11863.field_9236) {
            this.sendData();
        }
    }

    public float getHourArmSpeed() {
        float speed = this.getAngularSpeed() / 2.0f;
        if (speed != 0.0f) {
            ClockHands mode = ClockHands.values()[this.operationMode.getValue()];
            float hourTarget = mode == ClockHands.HOUR_FIRST ? this.getHourTarget(false) : (mode == ClockHands.MINUTE_FIRST ? this.getMinuteTarget() : this.getHourTarget(true));
            float shortestAngleDiff = AngleHelper.getShortestAngleDiff(this.hourAngle, hourTarget);
            speed = shortestAngleDiff < 0.0f ? Math.max(speed, shortestAngleDiff) : Math.min(-speed, shortestAngleDiff);
        }
        return speed + this.clientHourAngleDiff / 3.0f;
    }

    public float getMinuteArmSpeed() {
        float speed = this.getAngularSpeed();
        if (speed != 0.0f) {
            ClockHands mode = ClockHands.values()[this.operationMode.getValue()];
            float minuteTarget = mode == ClockHands.MINUTE_FIRST ? this.getHourTarget(false) : this.getMinuteTarget();
            float shortestAngleDiff = AngleHelper.getShortestAngleDiff(this.minuteAngle, minuteTarget);
            speed = shortestAngleDiff < 0.0f ? Math.max(speed, shortestAngleDiff) : Math.min(-speed, shortestAngleDiff);
        }
        return speed + this.clientMinuteAngleDiff / 3.0f;
    }

    protected float getHourTarget(boolean cycle24) {
        boolean isNatural = this.field_11863.method_8597().comp_645();
        int dayTime = (int)(this.field_11863.method_8532() * (long)(isNatural ? 1 : 24) % 24000L);
        int hours = (dayTime / 1000 + 6) % 24;
        int offset = ((class_2350)this.method_11010().method_11654((class_2769)ClockworkBearingBlock.FACING)).method_10171().method_10181();
        float hourTarget = (float)(offset * -360) / (cycle24 ? 24.0f : 12.0f) * (float)(hours % (cycle24 ? 24 : 12));
        return hourTarget;
    }

    protected float getMinuteTarget() {
        boolean isNatural = this.field_11863.method_8597().comp_645();
        int dayTime = (int)(this.field_11863.method_8532() * (long)(isNatural ? 1 : 24) % 24000L);
        int minutes = dayTime % 1000 * 60 / 1000;
        int offset = ((class_2350)this.method_11010().method_11654((class_2769)ClockworkBearingBlock.FACING)).method_10171().method_10181();
        float minuteTarget = (float)(offset * -360) / 60.0f * (float)minutes;
        return minuteTarget;
    }

    public float getAngularSpeed() {
        float speed = -Math.abs(this.getSpeed() * 3.0f / 10.0f);
        if (this.field_11863.field_9236) {
            speed *= ServerSpeedProvider.get();
        }
        return speed;
    }

    public void assemble() {
        Pair<ClockworkContraption, ClockworkContraption> contraption;
        if (!(this.field_11863.method_8320(this.field_11867).method_26204() instanceof ClockworkBearingBlock)) {
            return;
        }
        class_2350 direction = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
        try {
            contraption = ClockworkContraption.assembleClockworkAt(this.field_11863, this.field_11867, direction);
            this.lastException = null;
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        if (contraption == null) {
            return;
        }
        if (contraption.getLeft() == null) {
            return;
        }
        if (((ClockworkContraption)contraption.getLeft()).getBlocks().isEmpty()) {
            return;
        }
        class_2338 anchor = this.field_11867.method_10093(direction);
        ((ClockworkContraption)contraption.getLeft()).removeBlocksFromWorld(this.field_11863, class_2338.field_10980);
        this.hourHand = ControlledContraptionEntity.create(this.field_11863, this, (Contraption)contraption.getLeft());
        this.hourHand.method_5814(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
        this.hourHand.setRotationAxis(direction.method_10166());
        this.field_11863.method_8649((class_1297)this.hourHand);
        if (((ClockworkContraption)contraption.getLeft()).containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
        if (contraption.getRight() != null) {
            anchor = this.field_11867.method_10079(direction, ((ClockworkContraption)contraption.getRight()).offset + 1);
            ((ClockworkContraption)contraption.getRight()).removeBlocksFromWorld(this.field_11863, class_2338.field_10980);
            this.minuteHand = ControlledContraptionEntity.create(this.field_11863, this, (Contraption)contraption.getRight());
            this.minuteHand.method_5814(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
            this.minuteHand.setRotationAxis(direction.method_10166());
            this.field_11863.method_8649((class_1297)this.minuteHand);
            if (((ClockworkContraption)contraption.getRight()).containsBlockBreakers()) {
                this.award(AllAdvancements.CONTRAPTION_ACTORS);
            }
        }
        this.award(AllAdvancements.CLOCKWORK_BEARING);
        this.running = true;
        this.hourAngle = 0.0f;
        this.minuteAngle = 0.0f;
        this.sendData();
    }

    public void disassemble() {
        if (!this.running && this.hourHand == null && this.minuteHand == null) {
            return;
        }
        this.hourAngle = 0.0f;
        this.minuteAngle = 0.0f;
        this.applyRotations();
        if (this.hourHand != null) {
            this.hourHand.disassemble();
        }
        if (this.minuteHand != null) {
            this.minuteHand.disassemble();
        }
        this.hourHand = null;
        this.minuteHand = null;
        this.running = false;
        this.sendData();
    }

    @Override
    public void attach(ControlledContraptionEntity contraption) {
        if (!(contraption.getContraption() instanceof ClockworkContraption)) {
            return;
        }
        ClockworkContraption cc = (ClockworkContraption)contraption.getContraption();
        this.method_5431();
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
        class_2338 anchor = this.field_11867.method_10079(facing, cc.offset + 1);
        if (cc.handType == ClockworkContraption.HandType.HOUR) {
            this.hourHand = contraption;
            this.hourHand.method_5814(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
        } else {
            this.minuteHand = contraption;
            this.minuteHand.method_5814(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
        }
        if (!this.field_11863.field_9236) {
            this.running = true;
            this.sendData();
        }
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10556("Running", this.running);
        compound.method_10548("HourAngle", this.hourAngle);
        compound.method_10548("MinuteAngle", this.minuteAngle);
        AssemblyException.write(compound, this.lastException);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        float hourAngleBefore = this.hourAngle;
        float minuteAngleBefore = this.minuteAngle;
        this.running = compound.method_10577("Running");
        this.hourAngle = compound.method_10583("HourAngle");
        this.minuteAngle = compound.method_10583("MinuteAngle");
        this.lastException = AssemblyException.read(compound);
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.running) {
            this.clientHourAngleDiff = AngleHelper.getShortestAngleDiff(hourAngleBefore, this.hourAngle);
            this.clientMinuteAngleDiff = AngleHelper.getShortestAngleDiff(minuteAngleBefore, this.minuteAngle);
            this.hourAngle = hourAngleBefore;
            this.minuteAngle = minuteAngleBefore;
        } else {
            this.hourHand = null;
            this.minuteHand = null;
        }
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.assembleNextTick = true;
    }

    @Override
    public boolean isValid() {
        return !this.method_11015();
    }

    @Override
    public float getInterpolatedAngle(float partialTicks) {
        if (this.isVirtual()) {
            return class_3532.method_16439((float)partialTicks, (float)this.prevForcedAngle, (float)this.hourAngle);
        }
        if (this.hourHand == null || this.hourHand.isStalled()) {
            partialTicks = 0.0f;
        }
        return class_3532.method_16439((float)partialTicks, (float)this.hourAngle, (float)(this.hourAngle + this.getHourArmSpeed()));
    }

    @Override
    public void onStall() {
        if (!this.field_11863.field_9236) {
            this.sendData();
        }
    }

    @Override
    public void remove() {
        if (!this.field_11863.field_9236) {
            this.disassemble();
        }
        super.remove();
    }

    @Override
    public boolean isAttachedTo(AbstractContraptionEntity contraption) {
        if (!(contraption.getContraption() instanceof ClockworkContraption)) {
            return false;
        }
        ClockworkContraption cc = (ClockworkContraption)contraption.getContraption();
        if (cc.handType == ClockworkContraption.HandType.HOUR) {
            return this.hourHand == contraption;
        }
        return this.minuteHand == contraption;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public class_2338 getBlockPosition() {
        return this.field_11867;
    }

    @Override
    public void setAngle(float forcedAngle) {
        this.hourAngle = forcedAngle;
    }

    static enum ClockHands implements INamedIconOptions
    {
        HOUR_FIRST(AllIcons.I_HOUR_HAND_FIRST),
        MINUTE_FIRST(AllIcons.I_MINUTE_HAND_FIRST),
        HOUR_FIRST_24(AllIcons.I_HOUR_HAND_FIRST_24);

        private String translationKey;
        private AllIcons icon;

        private ClockHands(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "contraptions.clockwork." + Lang.asId(this.name());
        }

        @Override
        public AllIcons getIcon() {
            return this.icon;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

